<?php
require_once 'config-db.php';

$providerId = $_POST['provider_id'] ?? null;
$page = max(1, (int)($_POST['page'] ?? 1));
$limit = max(1, min(50, (int)($_POST['limit'] ?? 20)));
$offset = ($page - 1) * $limit;

if (!$providerId) {
    echo '<p class="text-center text-white py-3">Provider not found.</p>';
    exit;
}

// Get games for this provider with pagination
$pdo = getDB();
$stmt = $pdo->prepare("
    SELECT g.*, p.provider_name, p.provider_image, p.provider_code
    FROM games g
    JOIN providers p ON g.provider_code = p.provider_code
    WHERE p.id = ? AND g.is_active = 1
    ORDER BY g.display_order ASC, g.id DESC
    LIMIT ? OFFSET ?
");
$stmt->execute([$providerId, $limit, $offset]);
$games = $stmt->fetchAll();

if (empty($games)) {
    echo '<p class="text-center text-white py-3">No games found for this provider.</p>';
    exit;
}

$daftarLink = getSetting('daftar_link', 'https://google.com');

foreach ($games as $game):
?>
<div class="card card-game d-flex">
    <div class="game-link">
        <a class="btn btn-game text-uppercase" onclick="login()">MAIN</a>
    </div>
    <div class="game-item">
        <img class="game-item-img" loading="lazy" src="<?= htmlspecialchars($game['game_image_path']) ?>" alt="<?= htmlspecialchars($game['game_name']) ?>" onerror="this.src='img/placeholder.png'">
    </div>
    <div class="percent">
        <p class="percent-txt" style="z-index: 15"></p>
        <div class="percent-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="" style="width: 0"></div>
    </div>
    <span class="card-title"><?= htmlspecialchars($game['game_name']) ?></span>
    <div class="jam">
        <div class="jamgacor jamBg">
            <h5 class="jamgacorRange"></h5>
        </div>
        <div class="pola jamBg">
            <h5>POLA MAIN</h5>
            <p class="pola1"></p>
            <p class="pola2"></p>
            <p class="pola3"></p>
        </div>
    </div>
</div>
<?php endforeach; ?>
