<?php
define('ADMIN_ACCESS', true);
require_once 'config/database.php';
require_once 'config/functions.php';

startSecureSession();
requireLogin();

$currentAdmin = getCurrentAdmin();
$pdo = getDBConnection();

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save'])) {
    $settings = [
        'meta_title' => sanitize($_POST['meta_title'] ?? ''),
        'meta_keywords' => sanitize($_POST['meta_keywords'] ?? ''),
        'meta_description' => sanitize($_POST['meta_description'] ?? ''),
        'canonical_url' => sanitize($_POST['canonical_url'] ?? ''),
        'site_logo' => sanitize($_POST['site_logo'] ?? ''),
        'site_favicon' => sanitize($_POST['site_favicon'] ?? ''),
        'theme_color' => sanitize($_POST['theme_color'] ?? ''),
        'marquee_text' => sanitize($_POST['marquee_text'] ?? ''),
        'daftar_link' => sanitize($_POST['daftar_link'] ?? ''),
        'site_name' => sanitize($_POST['site_name'] ?? ''),
        'banner_1' => sanitize($_POST['banner_1'] ?? ''),
        'banner_2' => sanitize($_POST['banner_2'] ?? ''),
        'banner_3' => sanitize($_POST['banner_3'] ?? ''),
    ];

    try {
        foreach ($settings as $key => $value) {
            $stmt = $pdo->prepare("UPDATE site_settings SET setting_value = ?, updated_at = NOW() WHERE setting_key = ?");
            $stmt->execute([$value, $key]);
        }
        setFlashMessage('success', 'Settings berhasil disimpan!');
        header('Location: settings.php');
        exit;
    } catch (Exception $e) {
        $error = 'Terjadi kesalahan: ' . $e->getMessage();
    }
}

$stmt = $pdo->query("SELECT * FROM site_settings ORDER BY setting_group, setting_key");
$settingsData = $stmt->fetchAll();

$settings = [];
foreach ($settingsData as $setting) {
    $settings[$setting['setting_key']] = $setting['setting_value'];
}

$flashMessage = getFlashMessage();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Saira:wght@400;500;600;700&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        h1, h2, h3, h4 { font-family: 'Saira', sans-serif; }
    </style>
</head>
<body class="bg-gray-50">

    <?php require_once 'includes/navbar.php'; ?>

    <main class="ml-64 p-8">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-800 mb-2">Website Settings</h1>
            <p class="text-gray-600">Kelola pengaturan website dan meta tags</p>
        </div>

        <?php if ($flashMessage): ?>
            <div class="mb-6">
                <?php if ($flashMessage['type'] === 'success'): ?>
                    <div class="bg-green-50 border-l-4 border-green-500 p-4 rounded-lg">
                        <div class="flex items-center">
                            <i class="ri-checkbox-circle-line text-2xl text-green-500 mr-3"></i>
                            <p class="text-green-800"><?= htmlspecialchars($flashMessage['message']) ?></p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6 rounded">
                <p class="text-red-700"><?= htmlspecialchars($error) ?></p>
            </div>
        <?php endif; ?>

        <form method="POST" class="space-y-6">
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
                    <i class="ri-seo-line text-blue-600 mr-2"></i>
                    Meta Tags & SEO
                </h2>

                <div class="space-y-4">
                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Meta Title</label>
                        <input type="text" name="meta_title" value="<?= htmlspecialchars($settings['meta_title'] ?? '') ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="RTP LIVE TERAKURAT | Situs Slot Online">
                    </div>

                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Meta Keywords</label>
                        <input type="text" name="meta_keywords" value="<?= htmlspecialchars($settings['meta_keywords'] ?? '') ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="RTP LIVE, slot gacor, slot online">
                    </div>

                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Meta Description</label>
                        <textarea name="meta_description" rows="3"
                                  class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                  placeholder="Website resmi dengan RTP LIVE terlengkap..."><?= htmlspecialchars($settings['meta_description'] ?? '') ?></textarea>
                    </div>

                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Canonical URL</label>
                        <input type="url" name="canonical_url" value="<?= htmlspecialchars($settings['canonical_url'] ?? '') ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="https://example.com">
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
                    <i class="ri-palette-line text-blue-600 mr-2"></i>
                    Appearance
                </h2>

                <div class="space-y-4">
                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Site Name</label>
                        <input type="text" name="site_name" value="<?= htmlspecialchars($settings['site_name'] ?? '') ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="BRAND">
                    </div>

                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Logo URL/Path</label>
                        <input type="text" name="site_logo" value="<?= htmlspecialchars($settings['site_logo'] ?? '') ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="img/logo.png or https://cdn.example.com/logo.png">
                        <p class="text-xs text-gray-500 mt-1">Bisa local path atau CDN URL</p>
                    </div>

                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Favicon URL/Path</label>
                        <input type="text" name="site_favicon" value="<?= htmlspecialchars($settings['site_favicon'] ?? '') ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="img/favicon.png">
                    </div>

                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Theme Color</label>
                        <select name="theme_color"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="merah" <?= ($settings['theme_color'] ?? 'merah') === 'merah' ? 'selected' : '' ?>>🔴 Merah (Red)</option>
                            <option value="biru" <?= ($settings['theme_color'] ?? '') === 'biru' ? 'selected' : '' ?>>🔵 Biru (Blue)</option>
                            <option value="hijau" <?= ($settings['theme_color'] ?? '') === 'hijau' ? 'selected' : '' ?>>🟢 Hijau (Green)</option>
                            <option value="ungu" <?= ($settings['theme_color'] ?? '') === 'ungu' ? 'selected' : '' ?>>🟣 Ungu (Purple)</option>
                            <option value="oranye" <?= ($settings['theme_color'] ?? '') === 'oranye' ? 'selected' : '' ?>>🟠 Oranye (Orange)</option>
                            <option value="pink" <?= ($settings['theme_color'] ?? '') === 'pink' ? 'selected' : '' ?>>🩷 Pink</option>
                            <option value="hitam" <?= ($settings['theme_color'] ?? '') === 'hitam' ? 'selected' : '' ?>>⚫ Hitam (Dark)</option>
                            <option value="emas" <?= ($settings['theme_color'] ?? '') === 'emas' ? 'selected' : '' ?>>🟡 Emas (Gold)</option>
                            <option value="royal" <?= ($settings['theme_color'] ?? '') === 'royal' ? 'selected' : '' ?>>💙 Royal (Navy & Pink)</option>
                        </select>
                        <p class="text-xs text-gray-500 mt-1">Pilih tema warna untuk frontend</p>
                    </div>

                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Banner Slider 1 URL</label>
                        <input type="text" name="banner_1" value="<?= htmlspecialchars($settings['banner_1'] ?? '') ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="img/slide1.jpg or https://cdn.example.com/banner1.jpg">
                        <p class="text-xs text-gray-500 mt-1">Banner slide pertama (bisa local atau CDN)</p>
                    </div>

                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Banner Slider 2 URL</label>
                        <input type="text" name="banner_2" value="<?= htmlspecialchars($settings['banner_2'] ?? '') ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="img/slide2.jpg or https://cdn.example.com/banner2.jpg">
                        <p class="text-xs text-gray-500 mt-1">Banner slide kedua (bisa local atau CDN)</p>
                    </div>

                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Banner Slider 3 URL</label>
                        <input type="text" name="banner_3" value="<?= htmlspecialchars($settings['banner_3'] ?? '') ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="img/slide3.jpg or https://cdn.example.com/banner3.jpg">
                        <p class="text-xs text-gray-500 mt-1">Banner slide ketiga (bisa local atau CDN)</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-6 flex items-center">
                    <i class="ri-text text-blue-600 mr-2"></i>
                    Content
                </h2>

                <div class="space-y-4">
                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Marquee Text (Running Text)</label>
                        <input type="text" name="marquee_text" value="<?= htmlspecialchars($settings['marquee_text'] ?? '') ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="Situs Slot Gacor Terbaik nomor 1 di indonesia">
                    </div>

                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Daftar/Login Link</label>
                        <input type="url" name="daftar_link" value="<?= htmlspecialchars($settings['daftar_link'] ?? '') ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="https://qoolink.co/bangunwin">
                    </div>
                </div>
            </div>

            <div class="flex space-x-3">
                <button type="submit" name="save" class="px-8 py-3 bg-blue-600 text-white rounded-lg font-semibold hover:bg-blue-700 transition shadow-lg">
                    <i class="ri-save-line mr-2"></i> Simpan Settings
                </button>
                <a href="dashboard.php" class="px-8 py-3 bg-gray-200 text-gray-700 rounded-lg font-semibold hover:bg-gray-300 transition">
                    <i class="ri-arrow-left-line mr-2"></i> Kembali
                </a>
            </div>
        </form>
    </main>

</body>
</html>
