<?php
define('ADMIN_ACCESS', true);
require_once 'config/database.php';
require_once 'config/functions.php';

startSecureSession();
requireLogin();

$currentAdmin = getCurrentAdmin();
$pdo = getDBConnection();

$action = $_GET['action'] ?? 'list';
$providerId = $_GET['id'] ?? null;
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['delete']) && $providerId) {
        $stmt = $pdo->prepare("DELETE FROM providers WHERE id = ?");
        $stmt->execute([$providerId]);
        setFlashMessage('success', 'Provider berhasil dihapus!');
        header('Location: providers.php');
        exit;
    }

    if (isset($_POST['save'])) {
        $providerCode = strtoupper(sanitize($_POST['provider_code'] ?? ''));
        $providerName = sanitize($_POST['provider_name'] ?? '');
        $providerImage = sanitize($_POST['provider_image'] ?? '');
        $providerLink = sanitize($_POST['provider_link'] ?? '');
        $totalGames = (int)($_POST['total_games'] ?? 0);
        $displayOrder = (int)($_POST['display_order'] ?? 0);
        $isActive = isset($_POST['is_active']) ? 1 : 0;

        if (empty($providerCode) || empty($providerName) || empty($providerImage)) {
            $error = 'Provider code, nama, dan gambar URL harus diisi!';
        } else {
            if ($providerId) {
                $stmt = $pdo->prepare("UPDATE providers SET provider_code = ?, provider_name = ?, provider_image = ?, provider_link = ?, total_games = ?, display_order = ?, is_active = ?, updated_at = NOW() WHERE id = ?");
                $stmt->execute([$providerCode, $providerName, $providerImage, $providerLink, $totalGames, $displayOrder, $isActive, $providerId]);
                setFlashMessage('success', 'Provider berhasil diupdate!');
            } else {
                $stmt = $pdo->prepare("INSERT INTO providers (provider_code, provider_name, provider_image, provider_link, total_games, display_order, is_active, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())");
                $stmt->execute([$providerCode, $providerName, $providerImage, $providerLink, $totalGames, $displayOrder, $isActive]);
                setFlashMessage('success', 'Provider berhasil ditambahkan!');
            }
            header('Location: providers.php');
            exit;
        }
    }
}

$stmt = $pdo->query("SELECT * FROM providers ORDER BY display_order ASC, provider_name ASC");
$providers = $stmt->fetchAll();

if ($action === 'edit' && $providerId) {
    $stmt = $pdo->prepare("SELECT * FROM providers WHERE id = ? LIMIT 1");
    $stmt->execute([$providerId]);
    $providerEdit = $stmt->fetch();
    if (!$providerEdit) {
        header('Location: providers.php');
        exit;
    }
}

$flashMessage = getFlashMessage();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Providers Management - Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Saira:wght@400;500;600;700&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        h1, h2, h3, h4 { font-family: 'Saira', sans-serif; }
    </style>
</head>
<body class="bg-gray-50">

    <?php require_once 'includes/navbar.php'; ?>

    <main class="ml-64 p-8">
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-800 mb-2">Providers Management</h1>
            <p class="text-gray-600">Kelola semua game provider</p>
        </div>

        <?php if ($flashMessage): ?>
            <div class="mb-6">
                <?php if ($flashMessage['type'] === 'success'): ?>
                    <div class="bg-green-50 border-l-4 border-green-500 p-4 rounded-lg">
                        <div class="flex items-center">
                            <i class="ri-checkbox-circle-line text-2xl text-green-500 mr-3"></i>
                            <p class="text-green-800"><?= htmlspecialchars($flashMessage['message']) ?></p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if ($action === 'add' || $action === 'edit'): ?>
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 mb-6">
                <h2 class="text-xl font-bold text-gray-800 mb-6"><?= $action === 'edit' ? 'Edit Provider' : 'Tambah Provider Baru' ?></h2>

                <?php if ($error): ?>
                    <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6 rounded">
                        <p class="text-red-700"><?= htmlspecialchars($error) ?></p>
                    </div>
                <?php endif; ?>

                <form method="POST" class="space-y-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-gray-700 font-medium mb-2 text-sm">Provider Code *</label>
                            <input type="text" name="provider_code" value="<?= isset($providerEdit) ? htmlspecialchars($providerEdit['provider_code']) : '' ?>" required
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                   placeholder="Contoh: PP, PG, HB" <?= isset($providerEdit) ? 'readonly' : '' ?>>
                        </div>

                        <div>
                            <label class="block text-gray-700 font-medium mb-2 text-sm">Provider Name *</label>
                            <input type="text" name="provider_name" value="<?= isset($providerEdit) ? htmlspecialchars($providerEdit['provider_name']) : '' ?>" required
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                   placeholder="Contoh: Pragmatic Play">
                        </div>
                    </div>

                    <div>
                        <label class="block text-gray-700 font-medium mb-2 text-sm">Provider Image URL/Path *</label>
                        <input type="text" name="provider_image" value="<?= isset($providerEdit) ? htmlspecialchars($providerEdit['provider_image']) : '' ?>" required
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                               placeholder="img/provider/pragmatic.png or https://cdn.example.com/logo.png">
                        <p class="text-xs text-gray-500 mt-1">Bisa local path (img/...) atau CDN URL (https://...) - Auto resize 90x90px</p>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-gray-700 font-medium mb-2 text-sm">Provider Link</label>
                            <input type="text" name="provider_link" value="<?= isset($providerEdit) ? htmlspecialchars($providerEdit['provider_link']) : '' ?>"
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                   placeholder="Optional">
                        </div>

                        <div>
                            <label class="block text-gray-700 font-medium mb-2 text-sm">Display Order</label>
                            <input type="number" name="display_order" value="<?= isset($providerEdit) ? $providerEdit['display_order'] : 999 ?>" min="0"
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500"
                                   placeholder="999 (semakin kecil semakin atas)">
                            <p class="text-xs text-gray-500 mt-1">Default 999 = paling bawah. Angka kecil = urutan atas</p>
                        </div>
                    </div>

                    <div>
                        <label class="flex items-center cursor-pointer">
                            <input type="checkbox" name="is_active" value="1" <?= (!isset($providerEdit) || $providerEdit['is_active']) ? 'checked' : '' ?>
                                   class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                            <span class="ml-2 text-gray-700">Provider Aktif</span>
                        </label>
                    </div>

                    <div class="flex space-x-3 pt-4">
                        <button type="submit" name="save" class="px-6 py-3 bg-blue-600 text-white rounded-lg font-semibold hover:bg-blue-700 transition">
                            <i class="ri-save-line mr-2"></i> <?= $action === 'edit' ? 'Update Provider' : 'Tambah Provider' ?>
                        </button>
                        <a href="providers.php" class="px-6 py-3 bg-gray-200 text-gray-700 rounded-lg font-semibold hover:bg-gray-300 transition">
                            <i class="ri-close-line mr-2"></i> Batal
                        </a>
                    </div>
                </form>
            </div>
        <?php else: ?>
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 mb-6">
                <div class="flex justify-between items-center mb-6">
                    <h2 class="text-xl font-bold text-gray-800">Daftar Providers</h2>
                    <a href="providers.php?action=add" class="px-6 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition font-medium">
                        <i class="ri-add-line mr-2"></i> Tambah Provider
                    </a>
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50 border-b border-gray-200">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Logo</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Code</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Total Games</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <?php foreach ($providers as $provider): ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="px-4 py-3">
                                        <div class="w-14 h-14 bg-gray-900 rounded-lg flex items-center justify-center p-2 shadow-sm">
                                            <img src="../<?= htmlspecialchars($provider['provider_image']) ?>"
                                                 alt="<?= htmlspecialchars($provider['provider_name']) ?>"
                                                 class="max-w-full max-h-full object-contain"
                                                 onerror="this.parentElement.innerHTML='<i class=\'ri-image-line text-gray-500 text-xl\'></i>'">
                                        </div>
                                    </td>
                                    <td class="px-4 py-3 text-sm font-medium text-gray-900">
                                        <span class="px-2 py-1 bg-purple-100 text-purple-800 rounded text-xs font-bold"><?= htmlspecialchars($provider['provider_code']) ?></span>
                                    </td>
                                    <td class="px-4 py-3 text-sm text-gray-900 font-medium"><?= htmlspecialchars($provider['provider_name']) ?></td>
                                    <td class="px-4 py-3 text-sm text-gray-900">
                                        <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded text-xs font-medium"><?= $provider['total_games'] ?> games</span>
                                    </td>
                                    <td class="px-4 py-3 text-sm text-gray-900">
                                        <span class="px-2 py-1 bg-gray-100 text-gray-800 rounded text-xs font-medium"><?= $provider['display_order'] ?></span>
                                    </td>
                                    <td class="px-4 py-3 text-sm">
                                        <?php if ($provider['is_active']): ?>
                                            <span class="px-2 py-1 bg-green-100 text-green-800 rounded text-xs font-medium">Aktif</span>
                                        <?php else: ?>
                                            <span class="px-2 py-1 bg-red-100 text-red-800 rounded text-xs font-medium">Nonaktif</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3 text-sm space-x-2">
                                        <a href="providers.php?action=edit&id=<?= $provider['id'] ?>" class="text-blue-600 hover:text-blue-800">
                                            <i class="ri-edit-line"></i> Edit
                                        </a>
                                        <form method="POST" action="providers.php?id=<?= $provider['id'] ?>" class="inline" onsubmit="return confirm('Yakin hapus provider ini?')">
                                            <button type="submit" name="delete" class="text-red-600 hover:text-red-800">
                                                <i class="ri-delete-bin-line"></i> Hapus
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <p class="text-center text-gray-600 mt-4 text-sm">Total: <?= count($providers) ?> providers</p>
            </div>
        <?php endif; ?>
    </main>

</body>
</html>
