<?php
// Get current page
$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$currentAdmin = getCurrentAdmin();
?>

<aside class="fixed left-0 top-0 h-full w-64 bg-white border-r border-gray-200 shadow-sm z-50">
    <div class="p-6">
        <div class="flex items-center space-x-3 mb-8">
            <div class="bg-blue-600 p-2 rounded-lg">
                <i class="ri-shield-keyhole-fill text-3xl text-white"></i>
            </div>
            <div>
                <h2 class="text-xl font-bold text-gray-800">Admin Panel</h2>
                <p class="text-xs text-gray-500">RTP Management</p>
            </div>
        </div>

        <nav class="space-y-2">
            <a href="dashboard.php" class="flex items-center space-x-3 px-4 py-3 <?= $currentPage === 'dashboard' ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-50' ?> rounded-lg font-medium transition">
                <i class="ri-dashboard-line text-xl"></i>
                <span>Dashboard</span>
            </a>
            <a href="games.php" class="flex items-center space-x-3 px-4 py-3 <?= $currentPage === 'games' ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-50' ?> rounded-lg font-medium transition">
                <i class="ri-gamepad-line text-xl"></i>
                <span>Games</span>
            </a>
            <a href="bulk-add-games.php" class="flex items-center space-x-3 px-4 py-3 pl-12 <?= $currentPage === 'bulk-add-games' ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-50' ?> rounded-lg font-medium transition text-sm">
                <i class="ri-file-list-3-line text-lg"></i>
                <span>Bulk Add Games</span>
            </a>
            <a href="providers.php" class="flex items-center space-x-3 px-4 py-3 <?= $currentPage === 'providers' ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-50' ?> rounded-lg font-medium transition">
                <i class="ri-store-line text-xl"></i>
                <span>Providers</span>
            </a>
            <a href="settings.php" class="flex items-center space-x-3 px-4 py-3 <?= $currentPage === 'settings' ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-50' ?> rounded-lg font-medium transition">
                <i class="ri-settings-3-line text-xl"></i>
                <span>Settings</span>
            </a>

            <!-- Divider -->
            <div class="border-t border-gray-200 my-4"></div>

            <!-- New Menu Items -->
            <a href="users.php" class="flex items-center space-x-3 px-4 py-3 <?= $currentPage === 'users' ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-50' ?> rounded-lg font-medium transition">
                <i class="ri-team-line text-xl"></i>
                <span>Users</span>
            </a>
            <a href="profile.php" class="flex items-center space-x-3 px-4 py-3 <?= $currentPage === 'profile' ? 'bg-blue-50 text-blue-600' : 'text-gray-700 hover:bg-gray-50' ?> rounded-lg font-medium transition">
                <i class="ri-user-settings-line text-xl"></i>
                <span>My Profile</span>
            </a>
        </nav>

        <div class="absolute bottom-6 left-6 right-6">
            <div class="bg-gray-50 rounded-lg p-4 mb-3">
                <div class="flex items-center space-x-3">
                    <div class="bg-blue-600 w-10 h-10 rounded-full flex items-center justify-center">
                        <span class="text-white font-bold text-sm">
                            <?= strtoupper(substr($currentAdmin['username'] ?? 'A', 0, 1)) ?>
                        </span>
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="font-medium truncate text-gray-800"><?= htmlspecialchars($currentAdmin['full_name'] ?? $currentAdmin['username']) ?></p>
                        <p class="text-xs text-gray-500 truncate"><?= htmlspecialchars($currentAdmin['email']) ?></p>
                    </div>
                </div>
            </div>
            <a href="logout.php" class="flex items-center justify-center space-x-2 px-4 py-3 bg-red-500 hover:bg-red-600 text-white rounded-lg transition font-medium">
                <i class="ri-logout-box-line text-xl"></i>
                <span>Logout</span>
            </a>
        </div>
    </div>
</aside>

<!-- Main content wrapper -->
<div class="ml-64">
